definition module ospicture


//	Version 1.0.2

//
//	Drawing functions and other operations on Pictures. 
//

from	StdFunc		import St
from	intrface	import HDC
from	osfont		import Font
from	ostoolbox	import OSToolbox
from	osrgn		import OSRgnHandle
import	StdPictureDef


::	Picture
::	Origin
	:==	Point
::	OSPictContext
	:==	HDC
::  Pen
	=	{	penSize			:: !Int				// The width and height of the pen
  		,	penForeColour	:: !Colour			// The drawing colour of the pen
		,	penBackColour	:: !Colour			// The background colour of the pen
		,	penPos			:: !Point			// The pen position in local coordinates
		,	penFont			:: !Font			// The font information to draw text and characters
		}

/*	Conversion operations to and from Picture.
	To open/close a picture context:
		packPicture   creates a Picture, given the proper OS resources. The picture is initialised.
		unpackPicture unpacks a Picture, releasing the proper OS resources.
	To open/close an existing picture:
		peekPicture   gives you the components of a Picture
		unpeekPicture restores the components to a Picture
	To obtain a read-only picture:
		sharePicture  creates a copy of the Picture. This copy does not occupy OS resources.
	To obtain temporary access to the screen:
		peekScreen    creates a window picture, applies the argument function to it, and releases the OS resources. 
*/
packPicture				:: !Origin !Pen !OSPictContext !*OSToolbox -> *Picture
unpackPicture			:: !*Picture -> (!Origin,!Pen,!OSPictContext,!*OSToolbox)
peekPicture				:: !*Picture -> (!Origin,!Pen,!OSPictContext,!*OSToolbox)
unpeekPicture			:: !Origin !Pen !OSPictContext !*OSToolbox -> *Picture
peekOSPictContext		:: !*Picture -> (!OSPictContext,!*Picture)
sharePicture			:: !*Picture -> (!Picture,!*Picture)

peekScreen				:: !(St *Picture .x) !*OSToolbox -> (!.x,!*OSToolbox)

defaultPen				:: Pen		// The Pen for customised drawing operations
dialogPen				:: Pen		// The Pen for system     drawing operations


//	Picture interface functions.
apppicttoolbox			:: !(IdFun *OSToolbox)		!*Picture -> *Picture
accpicttoolbox			:: !(St *OSToolbox .x)		!*Picture -> (!.x,!*Picture)


/*	Attribute functions.
*/
//	Access to Origin and Pen:
setpictpen				:: !Pen						!*Picture -> *Picture
getpictpen				::							!*Picture -> (!Pen,   !*Picture)
setpictorigin			:: !Origin					!*Picture -> *Picture
getpictorigin			::							!*Picture -> (!Origin,!*Picture)

//	PenPos attributes:
setpictpenpos			:: !Point					!*Picture -> *Picture
getpictpenpos			::							!*Picture -> (!Point,!*Picture)
movepictpenpos			:: !Vector					!*Picture -> *Picture
// Move the pen position over the given vector

//	PenSize attributes:
setpictpensize			:: !Int						!*Picture -> *Picture 	
getpictpensize			::							!*Picture -> (!Int,!*Picture)

//	PenColour attributes:
accpictpencolour		::							!*Picture -> (!Colour,!*Picture)
setpictpencolour		:: !Colour					!*Picture -> *Picture
setpictbackcolour		:: !Colour					!*Picture -> *Picture
getpictpencolour		::							!*Picture -> (!Colour,!*Picture)
getpictbackcolour		::							!*Picture -> (!Colour,!*Picture)

//	PenFont attributes:
setpictpenfont			:: !Font					!*Picture -> *Picture
getpictpenfont			::							!*Picture -> (!Font,!*Picture)
setpictpendefaultfont	::							!*Picture -> *Picture
//	setpictpendefaultfont opens and sets the defaultFont (see StdFont).


/*	Drawing mode setting functions.
*/
setpictxormode			::							!*Picture -> *Picture
setpicthilitemode		::							!*Picture -> *Picture
setpictnormalmode		::							!*Picture -> *Picture


/*	Point drawing operations.
	pictdrawpoint
		only draws a point at that position. The pen position is not changed.
*/
pictdrawpoint			:: !Point					!*Picture -> *Picture


/*	Line drawing operations.
	pictdrawlineto
		draws a line from the current pen position to the given pen position. 
		The new pen position is the endpoint of the line.	
	pictdrawline
		draws a line from the first point to the second point. The pen position
		is not changed.
	pictundrawlineto
		is the same as pictdrawlineto except that temporarily the background colour is used.
	pictundrawline
		is the same as pictdrawline except that temporarily the background colour is used.
*/
pictdrawlineto			:: !Point					!*Picture -> *Picture
pictdrawline			:: !Point !Point			!*Picture -> *Picture
pictundrawlineto		:: !Point					!*Picture -> *Picture
pictundrawline			:: !Point !Point			!*Picture -> *Picture


/*	Text drawing operations.
	pictdraw(char/string) draws a char/string at the current pen position. The new
		pen position is immediately after the drawn char/string.
*/
pictdrawchar			:: !Char					!*Picture -> *Picture
pictundrawchar			:: !Char					!*Picture -> *Picture
pictdrawstring			:: !String					!*Picture -> *Picture
pictundrawstring		:: !String					!*Picture -> *Picture


/*	Oval drawing operations.
	pict(draw/fill)oval center oval 
		draws/fills an oval at center with horizontal and vertical radius. The new
		pen position is not changed.
	pict(undraw/unfill)oval center oval
		draw/fill an oval at center with horizontal and vertical radius using the
		background colour of the picture.
*/
pictdrawoval			:: !Point !Oval				!*Picture -> *Picture
pictfilloval			:: !Point !Oval				!*Picture -> *Picture
pictundrawoval			:: !Point !Oval				!*Picture -> *Picture
pictunfilloval			:: !Point !Oval				!*Picture -> *Picture


/*	Curve drawing operations.
	pict(draw/fill)curve movePen point curve
		draws/fills a curve starting at point with a shape defined by curve. If movePen
		is True, then the new pen position is at the end of the curve, otherwise it does
		not change.
	pictun(draw/fill)curve 
		is equal to pict(draw/fill)curve, using the background colour temporarily.
	getcurve_rect_begin_end point curve
		returns the enclosing rect of the curve and begin and end point lying on that
		curve.
*/
pictdrawcurve			:: !Bool !Point !Curve		!*Picture -> *Picture
pictundrawcurve			:: !Bool !Point !Curve		!*Picture -> *Picture
pictfillcurve			:: !Bool !Point !Curve		!*Picture -> *Picture
pictunfillcurve			:: !Bool !Point !Curve		!*Picture -> *Picture
getcurve_rect_begin_end	:: !Point !Curve					  -> (!(!Int,!Int,!Int,!Int),!Point,!Point)


/*	Rect drawing operations.
	pict(draw/fill)rect rect
		draws/fills a rect. The pen position is not changed.
	pictun(draw/fill)rect 
		is equal to pict(draw/fill)rect, using the background colour temporarily.
*/
pictdrawrect			:: !(!Int,!Int,!Int,!Int)	!*Picture -> *Picture
pictundrawrect			:: !(!Int,!Int,!Int,!Int)	!*Picture -> *Picture
pictfillrect			:: !(!Int,!Int,!Int,!Int)	!*Picture -> *Picture
pictunfillrect			:: !(!Int,!Int,!Int,!Int)	!*Picture -> *Picture


/*	Polygon drawing operations.
	pict(draw/fill)polygon point polygon
		draws/fills a polygon starting at point. The pen position is not changed.
	pictun(draw/fill)polygon
		is equal to pict(draw/fill)polygon, using the background colour temporarily.
*/
pictdrawpolygon			:: !Point !Polygon			!*Picture -> *Picture
pictundrawpolygon		:: !Point !Polygon			!*Picture -> *Picture
pictfillpolygon			:: !Point !Polygon			!*Picture -> *Picture
pictunfillpolygon		:: !Point !Polygon			!*Picture -> *Picture


/*	Clipping operations.
	pictgetcliprgn gets the current clipping region.
	pictsetcliprgn sets the given clipping region.
	pictandcliprgn takes the intersection of the current clipping region and the argument region.
*/
pictgetcliprgn			::							!*Picture -> (!OSRgnHandle,!*Picture)
pictsetcliprgn			:: !OSRgnHandle				!*Picture -> *Picture
pictandcliprgn			:: !OSRgnHandle				!*Picture -> *Picture

/*	Resolution access function (added by MW):
*/
getResolutionC :: !OSPictContext !*OSToolbox -> (!(!Int,!Int),!*OSToolbox)

// MW: scaling of screen coordinates to printer coordinates.
getPictureScalingFactors :: !OSPictContext !*OSToolbox -> (!(!Int,!Int),!(!Int,!Int),!OSPictContext,!*OSToolbox)

